﻿
Partial Class _Default
    Inherits System.Web.UI.Page

    'page header - declares constants used in the code
    'create an instance of the site info class to store important data about the site
    Dim ThisSite As New SiteInfo
    'this constant is used to test if no item has been selected in the list
    Const NO_ITEM As Integer = -1
    'used to store the details of the current user
    Dim TheCurrentUser As New SwapShopUser

    'var to store the number of login attempts
    Dim Attempts As Integer

    Protected Sub btnSubmit_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSubmit.Click
        'var to store the error message
        Dim ErrMsg As String
        'var to store the title of the swap
        Dim OfferTitle As String
        'var to store the swap title
        Dim SwapTitle As String
        'var to store the description of the swap
        Dim Description As String
        'var to store the unique identifier of the swap
        Dim SwapNo As Integer
        'var to store the unique identifier of the current user
        Dim Userno As Integer
        'var to store the email address of the current user
        Dim EMail As String
        'var to store the username of the current user
        Dim UserName As String
        'var to flagg the successful send of the email
        Dim Success As Boolean
        'get the selected index of the selected swap
        'SwapIndex = lstSwaps.SelectedIndex
        'validate the offer by calling the offer valid function
        ErrMsg = OfferValid()
        'clear the error message label
        lblError.Text = ""
        'if the error message is blank
        If ErrMsg = "" Then
            'get the title of the offer
            OfferTitle = txtOfferTitle.Text
            'get the description of the offer
            Description = txtOfferDescription.Text
            'get the full name of the current user
            UserName = TheCurrentUser.FirstName & " " & TheCurrentUser.LastName
            'get the email address of the current user
            EMail = TheCurrentUser.EMail
            'get the user number of the current user
            Userno = TheCurrentUser.UserNo
            'get the unique identifier of the selected swap
            SwapNo = lstSwaps.SelectedValue
            'save the offer
            Call SaveOffer(SwapNo, Userno, OfferTitle, Description)
            'get teh swap title
            SwapTitle = lstSwaps.SelectedItem.Text
            'send an email to the site owner
            Success = EMailOwner(UserName, EMail, SwapTitle)
            'if the email was sent successfully
            If Success = True Then
                'display a message to the user
                lblError.Text = "An Email has been sent to the site owner notifying them of your offer."
                'clear the offer title
                txtOfferTitle.Text = ""
                'clear the offer description
                txtOfferDescription.Text = ""
            Else
                'show a message that the email could not be sent
                lblError.Text = "There was a problem sending the notification email to the site owner."
            End If
        Else
            'display the error message
            lblError.Text = ErrMsg
        End If
    End Sub

    Protected Sub btnLogin_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnLogin.Click
        'this code checks the user name and password and logs them in if they are correct
        'var to store the users email address
        Dim EMail As String
        'var to store the users password
        Dim Password As String
        'clear the error message
        lblError.Text = ""
        'get the EMail of the user
        EMail = txtEMail.Text
        'get the password
        Password = txtPassword.Text
        'create a new current user object using this user name and password
        TheCurrentUser = New SwapShopUser(EMail, Password)
        'if the email and password combination are correct then authenticated should be true
        If TheCurrentUser.Authenticated = True Then
            'call the sub to manage the interface
            Call ManageInterface()
            'clear the email address
            txtEMail.Text = ""
            'clear the password
            txtPassword.Text = ""
        Else
            'the email / password combination were not valid
            'increase the number of attempts by one
            Attempts = Attempts + 1
            'display an error message
            lblError.Text = "You must enter a valid user name and password."
        End If
    End Sub

    Protected Sub btnSignUp_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSignUp.Click
        'redirect to the sign up page
        Response.Redirect("signup.aspx")
    End Sub

    Protected Sub btnManageSwaps_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnManageSwaps.Click
        'redirect to the swap manager page
        Response.Redirect("swapmanager.aspx")
    End Sub

    Protected Sub btnWishList_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnWishList.Click
        'redirect to the wishlist page
        Response.Redirect("wishlist.aspx")
    End Sub

    Protected Sub btnResend_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnResend.Click
        'redirect to the resend password page
        Response.Redirect("resend.aspx")
    End Sub

    Protected Sub btnChange_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnChange.Click
        'redirect to the change password page
        Response.Redirect("changepassword.aspx")
    End Sub

    Protected Sub btnLogout_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnLogout.Click
        'this logs the user out of the system
        'clear the current user details
        TheCurrentUser = New SwapShopUser
        'call the sub to manage the interface
        Call ManageInterface()
    End Sub

    Protected Sub btnSearch_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnSearch.Click
        'apply the filter
        Call ApplyFilter(txtSearch.Text)
    End Sub

    Protected Sub btnClear_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles btnClear.Click
        'clear the filter
        txtSearch.Text = ""
        'apply the filter
        Call ApplyFilter(txtSearch.Text)
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        Dim Filter As String
        'this event runs when the page is loaded at the server
        'if this is the first time the page has loaded
        If IsPostBack = False Then
            'set the number of login attempts to zero
            Attempts = 0
            'get the search filter
            Filter = txtSearch.Text
            'display list of swaps
            lblResultsCount.Text = ListMySwaps(Filter)
        Else
            'if it is a page reload then get the current value from the session object
            Attempts = Session("Attempts")
        End If
        'if there have been too many failed login attempts
        If Attempts >= 2 Then
            'redirect to the badlogin page
            Response.Redirect("badlogin.aspx")
        End If
        'get the current user from the session object
        TheCurrentUser = Session("TheCurrentUser")
        'if the current user is nothing then this is the first time the page has loaded
        If TheCurrentUser Is Nothing Then
            'initialise the current user
            TheCurrentUser = New SwapShopUser
        End If
        'manage the interface
        Call ManageInterface()
    End Sub

    Protected Sub Page_Unload(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Unload
        'this code runs each time the page is unloaded at the server
        'save the current user details in the session object
        Session("TheCurrentUser") = TheCurrentUser
        'save the number of login attempts in the session object
        Session("Attempts") = Attempts
    End Sub

    Sub ManageInterface()
        'this sub makes controls visible/invisible depending on if the current user is logged in
        'and also if the current user is an administrator
        'var to store if the current user is logged in
        Dim LoggedIn As Boolean = TheCurrentUser.Authenticated
        'var to store if the current user is an administrator
        Dim IsAdmin As Boolean = TheCurrentUser.Administrator
        'if logged in then show the panel allowing people to make swap offers
        panSwap.Visible = LoggedIn
        'if logged in then show the change password button
        btnChange.Visible = LoggedIn
        'if logged in then show the logout button
        btnLogout.Visible = LoggedIn
        'if logged in then hide the panel allowing users to login
        panLogin.Visible = Not LoggedIn
        'if the current user is an administrator then display the manage swaps button
        btnManageSwaps.Visible = IsAdmin
        'if no swap is selected
        If lstSwaps.SelectedIndex = NO_ITEM Then
            'hide the swap description label
            lblSwapDescription.Visible = False
            'hide the swap picture
            picImageFile.Visible = False
        Else
            'display the description
            lblSwapDescription.Visible = True
            'display the picture
            picImageFile.Visible = True
        End If
        'if the user is not logged in
        If LoggedIn = False Then
            'clear the offer title text box
            txtOfferTitle.Text = ""
            'clear the offer description text box
            txtOfferDescription.Text = ""
        End If
    End Sub

    '####################################
    'swap listing code

    Function ListMySwaps(ByVal Filter As String) As String
        'this function lists swaps in the list box
        'it takes one parameter which is a filter
        'it returns a string indicating how many swaps were found
        '
        'var to store the SwapNo (unique identifier)
        Dim SwapNo As Integer
        'var to stor the swap title
        Dim Title As String
        'create a connection to the database table applying the filter
        Dim MySwaps As New DatabaseTable("dvd.mdb", "select * from swap where title like('" & Filter & "%') order by title", "#PN", "#PW")
        'var to store the number of swaps found
        Dim SwapCount As Integer
        'counter for the loop
        Dim Counter As Integer
        'get the number of swaps found
        SwapCount = MySwaps.Count
        'clear the list box
        lstSwaps.Items.Clear()
        'loop through each swap
        For Counter = 0 To SwapCount - 1
            'get the SwapNo from the database
            SwapNo = MySwaps.RecordNumber(Counter).Item("SwapNo")
            'get the Title of the swap from the database
            Title = MySwaps.RecordNumber(Counter).Item("Title")
            'add the title to the list
            lstSwaps.Items.Add(Title)
            'set the value of the item in the list to the SwapNo 
            lstSwaps.Items.Item(Counter).Value = SwapNo
        Next
        'if records were found
        If MySwaps.Count > 0 Then
            'return how many records were found
            Return MySwaps.Count & " record(s) found"
        Else
            'return no records found
            Return "No records found"
        End If
    End Function

    Protected Sub lstSwaps_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles lstSwaps.SelectedIndexChanged
        'this code runs when the user clicks on a swap in the list
        '
        'var to store the SwapNo
        Dim SwapNo As Integer
        'get the SwapNo of the item clicked on
        SwapNo = lstSwaps.SelectedValue
        'display the image for that record
        picImageFile.ImageUrl = GetSwapImage(SwapNo)
        'display the description for that record
        lblSwapDescription.Text = GetSwapDescription(SwapNo)
        'update the interface
        Call ManageInterface()
    End Sub

    Function GetSwapImage(ByVal SwapNo As Integer) As String
        'this function looks up the image name for the SwapNo
        'it returns the name of the image
        '
        'var to store the name of the image
        Dim ImageFile As String
        'find the record for this swap
        Dim MySwaps As New DatabaseTable("dvd.mdb", "select * from swap where swapno=" & SwapNo, "#PN", "#PW")
        'if the record has been found
        If MySwaps.Count = 1 Then
            'get the name of the image
            ImageFile = MySwaps.RecordNumber(0).Item("ImageFile")
            'return the image name
            Return ImageFile
        Else
            'otherwise return a blank string
            Return ""
        End If
    End Function

    Function GetSwapDescription(ByVal SwapNo As Integer) As String
        'this function looks up the description of the swap for SwapNo
        'it returns the description of the swap
        '
        'var to store the description
        Dim Description As String
        'find the record for this swap
        Dim MySwaps As New DatabaseTable("dvd.mdb", "select * from swap where swapno=" & SwapNo, "#PN", "#PW")
        'if the record has been found
        If MySwaps.Count = 1 Then
            'get the description
            Description = MySwaps.RecordNumber(0).Item("Description")
            'return the description
            Return Description
        Else
            'otherwise return a blank string
            Return ""
        End If
    End Function

    Sub SwapListed(ByVal SwapID As Integer)
        'this sub looks up the SwapId in the swap list and makes the item selected if found
        '
        'var to flag found
        Dim Found As Boolean
        'counter for the loop
        Dim Counter As Integer
        'var to store the number of swaps in the list
        Dim SwapCount As Integer
        'used to store the SwapId from the list box
        Dim ListedSwapID As Integer
        'initialise found as false
        Found = False
        'get the number of swaps in the list
        SwapCount = lstSwaps.Items.Count
        'initialise the counter
        Counter = 0
        'loop through each record until all records are done or we find what we want
        Do While Found = False And Counter < SwapCount
            'get the id for this swap in the list
            ListedSwapID = lstSwaps.Items.Item(Counter).Value
            'if this is the same ias the id passed as a parameter
            If ListedSwapID = SwapID Then
                'make this entry in the list the selected one
                lstSwaps.SelectedIndex = Counter
                'flag found as true
                Found = True
            Else
                'increment the counter
                Counter = Counter + 1
            End If
        Loop
    End Sub

    Sub ApplyFilter(ByVal Filter As String)
        'this sub applies the filter 
        'var to store the SwapID
        Dim SwapID As Integer
        'if a swap is selected in the list
        If lstSwaps.SelectedIndex <> NO_ITEM Then
            'get the SwapID
            SwapID = lstSwaps.SelectedValue
        End If
        'apply the filter
        lblResultsCount.Text = ListMySwaps(Filter)
        'if the SwapID is still in the list
        Call SwapListed(SwapID)
        'update the interface
        Call ManageInterface()
    End Sub

    '####################################
    'swap offer code

    Function OfferValid() As String
        'this function validates the offer made and returns an error message as a string
        'if there are problems
        '
        'var to store the error message
        Dim ErrMsg As String
        'initialise the error message
        ErrMsg = ""
        'if no swap has been selected
        If lstSwaps.SelectedIndex = NO_ITEM Then
            'add error message
            ErrMsg = ErrMsg & " you must select an item that you want "
        End If
        'if the title is blank
        If txtOfferTitle.Text = "" Then
            'add an error message
            ErrMsg = ErrMsg & " you must state the title of your offer "
        End If
        'if description is blank
        If txtOfferDescription.Text = "" Then
            'add an error message
            ErrMsg = ErrMsg & " you must state the description of your offer "
        End If
        'return the error message
        Return ErrMsg
    End Function

    Sub SaveOffer(ByVal SwapNo As Integer, ByVal UserNo As Integer, ByVal OfferTitle As String, ByVal OfferDescription As String)
        'this sub saves the offer to the database
        '
        'open a connection to the database table
        Dim Offers As New DatabaseTable("dvd.mdb", "select * from offer", "#PN", "#PW")
        'save the swap no to the new record
        Offers.NewRecord.Item("SwapNo") = SwapNo
        'save the user no to the new record
        Offers.NewRecord.Item("UserNo") = UserNo
        'save the offer title to the new record
        Offers.NewRecord.Item("Title") = OfferTitle
        'save the offer description to the new record
        Offers.NewRecord.Item("Description") = OfferDescription
        'add the new record
        Offers.AddNewRecord()
        'save the new record
        Offers.SaveChanges()
    End Sub

    Function EMailOwner(ByVal UserName As String, ByVal EMail As String, ByVal OfferTitle As String) As Boolean
        'this function sends an email to the site owner
        'it returns true or false if the email was sent or not
        '
        'var to store success
        Dim Success As Boolean
        'instance of the email object
        Dim AnEmail As New MyEMail
        'send the email
        Success = AnEmail.SendEMail(EMail, ThisSite.OwnerEMail, "An offer has been made on one of your swaps", UserName & " has made an offer on " & OfferTitle)
        'return the outcome
        Return Success
    End Function

End Class
